#ifndef PLATFORM_H
#define PLATFORM_H

#include <MKL25Z4.H>

typedef enum {
	PTA0 = (0 << 16) | 0,
	PTA1 = (0 << 16) | 1,
	PTA2 = (0 << 16) | 2,
	PTA3 = (0 << 16) | 3,
	PTA4 = (0 << 16) | 4,
	PTA5 = (0 << 16) | 5,
	PTA6 = (0 << 16) | 6,
	PTA7 = (0 << 16) | 7,
	PTB0 = (1 << 16) | 0,
	PTB1 = (1 << 16) | 1,
	PTB2 = (1 << 16) | 2,
	PTB3 = (1 << 16) | 3,
	PTB4 = (1 << 16) | 4,
	PTB5 = (1 << 16) | 5,
	PTB6 = (1 << 16) | 6,
	PTB7 = (1 << 16) | 7,
	PTB18= (1 << 16) |18,//Red LED
	PTB19= (1 << 16) |19,//Green LED
	PTC0 = (2 << 16) | 0,
	PTC1 = (2 << 16) | 1,
	PTC2 = (2 << 16) | 2,
	PTC3 = (2 << 16) | 3,
	PTC4 = (2 << 16) | 4,
	PTC5 = (2 << 16) | 5,
	PTC6 = (2 << 16) | 6,
	PTC7 = (2 << 16) | 7,
	PTD0 = (3 << 16) | 0,
	PTD1 = (3 << 16) | 1,//Blue LED
	PTD2 = (3 << 16) | 2,
	PTD3 = (3 << 16) | 3,
	PTD4 = (3 << 16) | 4,
	PTD5 = (3 << 16) | 5,
	PTD6 = (3 << 16) | 6,
	PTD7 = (3 << 16) | 7,
	PTE0 = (4 << 16) | 0,
	PTE1 = (4 << 16) | 1,
	PTE2 = (4 << 16) | 2,
	PTE3 = (4 << 16) | 3
} Pin;

#define LED_NUM 3

static Pin LED[LED_NUM]={PTB18,PTB19,PTD1};
static Pin SWITCH = PTA1;

#define LED_ON 0
#define LED_OFF 1

#define RED 0
#define GREEN 1
#define BLUE 2


#define CLK_FREQ 48000000UL

#define GET_PORT_INDEX(pin) ((pin) >> 16)
#define GET_PIN_INDEX(pin) ((pin) & 0xFF)

#define GET_PORT(pin) ((PORT_Type*)(PORTA_BASE + 0x1000 * GET_PORT_INDEX(pin)))
#define GET_FPT(pin) ((FGPIO_Type*)(FPTA_BASE + 0x40 * GET_PORT_INDEX(pin)))

#endif

// *******************************ARM University Program Copyright  ARM Ltd 2014*************************************   
